const { createApp, ref, onMounted } = Vue;
const application = createApp({
  components: {
    vSelect: window["vue-select"],
  },
  data() {
    return {
      name: "Malena Jalife",
      puesto: "Brand Executive",
      puestoProp: "Brand Executive",
      numero: "+ 000 000 00 00",
      numeroHotel: "+52 984 980 0678",
      email: "malena@nomadepeople.com",
      dominioSelected: {
        dominio: "nomadepeople",
        img: "sign-nomadepeople.jpg",
      },
      jsonDominio: [
        {
          dominio: "nomadetulum",
          img: "sign-nomadetulum.jpg",
          telefono: "+52 984 980 0678",
          ubicacion: "Tulum, México",
          rfc: "Ruasas Internacional SAPI de CV",
        },
        {
          dominio: "nomadeholbox",
          img: "sign-nomadeholbox.jpg",
          telefono: "+52 984 980 0678",
          ubicacion: "Holbox, México",
          rfc: "Buen Augurio SAPI de CV",
        },
        {
          dominio: "yaanhealingsanctuary",
          img: "sign-yaanhealingsanctuary.jpg",
          telefono: "+52 984 980 0678",
          ubicacion: "Tulum, México",
          rfc: "Tulum, México",
        },
        {
          dominio: "betulum",
          img: "sign-betulum.jpg",
          telefono: "+52 984 980 0678",
          ubicacion: "Tulum, México",
          rfc: "Triple S Logística SAPI de CV",
        },
        {
          dominio: "beplaya",
          img: "sign-beplaya.jpg",
          telefono: "+52 984 980 0678",
          ubicacion: "Tulum, México",
          rfc: "Tulum, México",
        },
        {
          dominio: "nomadepeople",
          img: "sign-nomadepeople.jpg",
        },
      ],

      fuente: "Stickler, Calibri, sans-serif",
      colaboradorSelected: {},
      jsonColaboradores: [
        {
          Name: "MANUEL MORENO",
          Position: "EXECUTIVE VICE PRESIDENT",
          Email: "MANUEL@NOMADEPEOPLE.COM",
        },
        {
          Name: "ALEJANDRO GONZALEZ",
          Position: "REGIONAL OPERATIONS DIRECTOR",
          Email: "ALEJANDRO.GONZALEZ@NOMADEPEOPLE.COM",
        },
        {
          Name: "[TBD DIRECTOR OF PROGRAMMING]",
          Position: "REGIONAL PROGRAMMING DIRECTOR",
          Email: "TBD",
        },
        {
          Name: "[TBD - F&B DIRECTOR]",
          Position: "REGIONAL F&B DIRECTOR",
          Email: "TBD",
        },
        {
          Name: "LUCIANO DANIEL SPADONI",
          Position: "HR MANAGER",
          Email: "LUCIANO@NOMADEPEOPLE.COM",
        },
        {
          Name: "DEBORA AMAXOPOLUS",
          Position: "OFFICE MANAGER BA",
          Email: "DEBORA@NOMADEPEOPLE.COM",
        },
        {
          Name: "[TBD - GLOBAL TALENT HR]",
          Position: "REGIONAL HR DIRECTOR",
          Email: "TBD",
        },
        {
          Name: "[DESIGNER TBD]",
          Position: "DESIGNER",
          Email: "TBD",
        },
        {
          Name: "[TBD - DIRECTOR OF SALES]",
          Position: "SALES DIRECTOR",
          Email: "TBD",
        },
        {
          Name: "[TBD - CALL CENTER]",
          Position: "CALL CENTER MANAGER",
          Email: "TBD",
        },
        {
          Name: "DANIELA FIGUEROLA",
          Position: "REVENUE MANAGEMENT & DISTRIBUTION DIRECTOR",
          Email: "DANIELA@NOMADEPEOPLE.COM",
        },
        {
          Name: "KEVIN O'DONNELL",
          Position: "REGIONAL MARKETING DIRECTOR",
          Email: "KEVIN@NOMADEPEOPLE.COM",
        },
        {
          Name: "SUSANA OSPINA LIZARRALDE ",
          Position: "BRANDS VICE PRESIDENT",
          Email: "SUSANA@NOMADEPEOPLE.COM",
        },
        {
          Name: "CARLOS MACIAS",
          Position: "MONOPOL PRODUCT LEADER & RESEARCHER",
          Email: "CARLOS@NOMADEPEOPLE.COM",
        },
        {
          Name: "MALENA JALIFE",
          Position: "BRAND ANALYST",
          Email: "MALENA@NOMADEPEOPLE.COM",
        },
        {
          Name: "CORAJE ABALOS",
          Position: "MONOPOL ASSISTANT",
          Email: "CORAJE@NOMADEPEOPLE.COM",
        },
        {
          Name: "ALEJANDRO DANIEL RODRIGUEZ ",
          Position: "ARCHITECTURE MANAGER",
          Email: "A.RODRIGUEZ@NOMADEPEOPLE.COM",
        },
        {
          Name: "SHIRLEY JEANETTE BRYF",
          Position: "ARCHITECT",
          Email: "SHIRLEY.BRYF@NOMADEPEOPLE.COM",
        },
        {
          Name: "BRENDA SPORN",
          Position: "SR ARCHITECT",
          Email: "BRENDA.SPORN@NOMADEPEOPLE.COM",
        },
        {
          Name: "MARTIN MASTRANTONIO",
          Position: "SR ARCHITECT",
          Email: "MARTIN.MASTRANTONIO@NOMADEPEOPLE.COM",
        },
        {
          Name: "BARBARA SANCHEZ",
          Position: "ARCHITECT",
          Email: "BARBARA.SANCHEZ@NOMADEPEOPLE.COM",
        },
        {
          Name: "EMILIANO GRANZELLA",
          Position: "ARCHITECT",
          Email: "E.GRANZELLA@NOMADEPEOPLE.COM",
        },
        {
          Name: "JUAN AGUSTIN DILLON",
          Position: "SR ARCHITECT",
          Email: "JUAN.DILLON@NOMADEPEOPLE.COM",
        },
        {
          Name: "LUNA TORRES",
          Position: "ARCHITECT",
          Email: "LUNA.TORRES@NOMADEPEOPLE.COM",
        },
        {
          Name: "BARBARA MARIA RODOWICZ",
          Position: "ARCHITECT",
          Email: "BARBARA.RODOWICZ@NOMADEPEOPLE.COM",
        },
        {
          Name: "GABRIEL LEVY",
          Position: "ARCHITECTURE OPERATIONS DIRECTOR (AIDSA)",
          Email: "GABRIEL.LEVY@NOMADEPEOPLE.COM",
        },
        {
          Name: "MARTIN PADULA",
          Position: "ARCHITECTURE MANAGER",
          Email: "MARTIN.PADULA@NOMADEPEOPLE.COM",
        },
        {
          Name: "[TBD - DESIGN ARCHITECT]",
          Position: "ARCHITECT",
          Email: "TBD",
        },
        {
          Name: "[TBD - DESIGN ARCHITECT]",
          Position: "ARCHITECT",
          Email: "TBD",
        },
        {
          Name: "[TBD - INTERIOR DESIGN]",
          Position: "INTERIOR DESIGN ARCHITECT",
          Email: "TBD",
        },
        {
          Name: "[TBD - INTERIOR DESIGN]",
          Position: "INTERIOR DESIGN ARCHITECT",
          Email: "TBD",
        },
        {
          Name: "CRISTHIAN ZABALA",
          Position: "FINANCE VICE PRESIDENT",
          Email: "CRISTHIAN@NOMADEPEOPLE.COM",
        },
        {
          Name: "ALEJANDRO WASERMAN",
          Position: "CONTROLLER",
          Email: "ALEJANDRO@NOMADEPEOPLE.COM",
        },
        {
          Name: "PAOLA COMINI",
          Position: "FP&A MANAGER",
          Email: "PAOLA@NOMADEPEOPLE.COM",
        },
        {
          Name: "[TBD - ACCOUNTING ANALYST)",
          Position: "ACCOUNTING ANALYST",
          Email: "DIEGO@NOMADEPEOPLE.COM",
        },
        {
          Name: "NATALIA PAZOS",
          Position: "ACCOUNTING MANAGER",
          Email: "TBD",
        },
        {
          Name: "MARIA VERONICA DI PASQUO",
          Position: "TSA & PROJECT MANAGER",
          Email: "VERONICA.DIPASQUO@NOMADEPEOPLE.COM",
        },
        {
          Name: "LEANDRO JUSTO NALLAR",
          Position: "FEASIBILITY ASSOCIATE",
          Email: "LEANDRO@NOMADEPEOPLE.COM",
        },
        {
          Name: "[FEASABILITY ANALYST]",
          Position: "FEASIBILITY ANALYST",
          Email: "TBD",
        },
        {
          Name: "MARTIN OCAMPO",
          Position: "TSA & PROJECT MANAGER",
          Email: "TBD",
        },
        {
          Name: "DANILO PARODI LOGIOCO",
          Position: "GENERAL COUNSEL",
          Email: "DANILO@NOMADEPEOPLE.COM",
        },
        {
          Name: "TOMAS RAGO",
          Position: "LEGAL MANAGER",
          Email: "TOMAS@NOMADEPEOPLE.COM",
        },
        {
          Name: "LUCIA DE LOS HEROS",
          Position: "LEGAL SPECIALIST IP & DATA PRIVACY LEADER",
          Email: "LUCIA@NOMADEPEOPLE.COM",
        },
        {
          Name: "GONZALO GOMEZ SOTELO",
          Position: "CORPORATE IT DIRECTOR",
          Email: "GONZALO.GOMEZ@NOMADEPEOPLE.COM",
        },
        {
          Name: "EMMANUEL IZQUIERDO DE LA CRUZ ",
          Position: "CLIENT SERVICE MANAGER",
          Email: "EMMANUEL.IZQUIERDO@NOMADEPEOPLE.COM",
        },
        {
          Name: "AITO DE LA RUA",
          Position: "PARTNERSHIPS VICE PRESIDENT",
          Email: "AITO@NOMADEPEOPLE.COM",
        },
        {
          Name: "FERNANDA BUSHMANN",
          Position: "MONOPOL MANAGER BA",
          Email: "FERNANDA@MONOPOL-LAB.COM",
        },
        {
          Name: "MATIAS MARTA",
          Position: "MAINTENANCE MONOPOL",
          Email: "TBD",
        },
        {
          Name: "NICOLAS MIRANDA",
          Position: "MAINTENANCE MONOPOL",
          Email: "TBD",
        },
        {
          Name: "JUAN ERASO",
          Position: "MONOPOL ASSISTANT",
          Email: "JUAN.ERASO@MONOPOL-LAB.COM",
        },
        {
          Name: "INDIRA",
          Position: "MAINTENANCE MONOPOL",
          Email: "TBD",
        },
        {
          Name: "MIGUEL ISLA",
          Position: "CEO",
          Email: "ISLA.M@NOMADEPEOPLE.COM",
        },
        {
          Name: "MARIEL POSSE",
          Position: "OFFICE SUPPORT",
          Email: "TBD",
        },
        {
          Name: "MIGUEL MENDEZ",
          Position: "PROGRAMMING DIRECTOR MEXICO",
          Email: "MIGUEL.MENDEZ@NOMADEPEOPLE.COM",
        },
          {   
  Name: "JUAN AGUSTIN LLANOS",
  Position: "OPENINGS & PM DIRECTOR",
  Email: "AGUSTIN@NOMADEPEOPLE.COM",
},
{
  Name: "ABRIL MIRANDA",
  Position: "BUSINESS EXECUTIVE ASSISTANT",
  Email: "ABRIL@NOMADEPEOPLE.COM",
},
{
  Name: "MAIA KRASNOV",
  Position: "ACCOUNTING ANALYST",
  Email: "MAIA@NOMADEPEOPLE.COM",
},
{
  Name: "MARIA QUINZIO",
  Position: "BRAND DIRECTOR",
  Email: "MARIA@NOMADEPEOPLE.COM",
},
        {
          Name: "[DESIGNER TBD]",
          Position: "DESIGNER",
          Email: "TBD",
        },
      ],
    };
  },
  methods: {
    clicked() {
      console.log("Copia de firma realizada!");
      const toast = new bootstrap.Toast(document.querySelector(".toast"));
      toast.show();
      //myModal.show();
      console.log("llamar a data");
      //call data file json
      // this.getDataFileJson();
    },
    splitMail(mail) {
      var newmail = {};
      newmail.name = mail.split("@")[0];
      var domain = mail.split("@")[1];
      newmail.domain = domain.split(".")[0];
      newmail.com = domain.split(".")[1];
      return newmail;
    },
    getDataFileJson() {
      //get file data.json
      fetch("assets/js/data.json")
        .then((response) => response.json())
        .then((data) => {
          // this.jsonData = data;
          console.log(data);
        });
    },
  },
  watch: {
    dominioSelected(val) {
      if (val.dominio == "yaanhealingsanctuary" || val.dominio == "betulum") {
        this.fuente = "Baskerville";
      } else {
        this.fuente = "Stickler, Calibri, sans-serif";
      }
    },
    colaboradorSelected(val) {
      this.name = val.Name;
      this.puesto = val.Position;
      this.email = val.Email;
    },
  },
  created() {
    this.nombres = this.jsonData;
  },
});
/**
application.directive("focus", {
  mounted(el) {
    el.focus();
  },
});

**/
application.mount("#container");

//application.component("v-select", VueSelect.VueSelect);

var clipboard = new Clipboard(".button");
